/* KMBEC FPGA (PRIO) */
#define CONFIG_SYS_KMBEC_FPGA_BASE	0xE8000000
#define CONFIG_SYS_KMBEC_FPGA_SIZE	64

/*
 * High Level Configuration Options
 */

/*
 * System IO Setup
 */
#define CONFIG_SYS_SICRH		(SICRH_UC1EOBI | SICRH_UC2E1OBI)

/**
 * DDR RAM settings
 */
#define CONFIG_SYS_DDR_SDRAM_CFG (\
	SDRAM_CFG_SDRAM_TYPE_DDR2 | \
	SDRAM_CFG_SREN | \
	SDRAM_CFG_HSE)

#define CONFIG_SYS_DDR_SDRAM_CFG2	0x00401000

#define CONFIG_SYS_DDR_CLK_CNTL (\
	DDR_SDRAM_CLK_CNTL_CLK_ADJUST_05)

#define CONFIG_SYS_DDR_INTERVAL (\
	(0x080 << SDRAM_INTERVAL_BSTOPRE_SHIFT) | \
	(0x203 << SDRAM_INTERVAL_REFINT_SHIFT))

#define CONFIG_SYS_DDR_CS0_BNDS			0x0000007f

#define CONFIG_SYS_DDRCDR (\
	DDRCDR_EN | \
	DDRCDR_Q_DRN)
#define CONFIG_SYS_DDR_MODE		0x47860452
#define CONFIG_SYS_DDR_MODE2		0x8080c000

#define CONFIG_SYS_DDR_TIMING_0 (\
	(2 << TIMING_CFG0_MRS_CYC_SHIFT) | \
	(8 << TIMING_CFG0_ODT_PD_EXIT_SHIFT) | \
	(6 << TIMING_CFG0_PRE_PD_EXIT_SHIFT) | \
	(2 << TIMING_CFG0_ACT_PD_EXIT_SHIFT) | \
	(0 << TIMING_CFG0_WWT_SHIFT) | \
	(0 << TIMING_CFG0_RRT_SHIFT) | \
	(0 << TIMING_CFG0_WRT_SHIFT) | \
	(0 << TIMING_CFG0_RWT_SHIFT))

#define CONFIG_SYS_DDR_TIMING_1	((TIMING_CFG1_CASLAT_50) | \
				 (2 << TIMING_CFG1_WRTORD_SHIFT) | \
				 (2 << TIMING_CFG1_ACTTOACT_SHIFT) | \
				 (3 << TIMING_CFG1_WRREC_SHIFT) | \
				 (7 << TIMING_CFG1_REFREC_SHIFT) | \
				 (3 << TIMING_CFG1_ACTTORW_SHIFT) | \
				 (8 << TIMING_CFG1_ACTTOPRE_SHIFT) | \
				 (3 << TIMING_CFG1_PRETOACT_SHIFT))

#define CONFIG_SYS_DDR_TIMING_2 (\
	(0xa << TIMING_CFG2_FOUR_ACT_SHIFT) | \
	(3 << TIMING_CFG2_CKE_PLS_SHIFT) | \
	(2 << TIMING_CFG2_WR_DATA_DELAY_SHIFT) | \
	(2 << TIMING_CFG2_RD_TO_PRE_SHIFT) | \
	(4 << TIMING_CFG2_WR_LAT_DELAY_SHIFT) | \
	(5 << TIMING_CFG2_CPO_SHIFT) | \
	(0 << TIMING_CFG2_ADD_LAT_SHIFT))

#define CONFIG_SYS_DDR_TIMING_3			0x00000000

/* EEprom support */
#define CONFIG_SYS_I2C_EEPROM_ADDR_LEN		2

/*
 * PAXE on the local bus CS3
 */
#define CONFIG_SYS_PAXE_BASE		0xA0000000
#define CONFIG_SYS_PAXE_SIZE		256
